#include <stdio.h>

#define MAX_STUDENTS 20


struct Student {
    int ID;
    char name[50];
    int age;
    char address[100];
};


void displayStudentDetails(struct Student students[], int numStudents, int targetID) {
    int found = 0;
    for (int i = 0; i < numStudents; i++) {
        if (students[i].ID == targetID) {
            printf("ID: %d\n", students[i].ID);
            printf("Name: %s\n", students[i].name);
            printf("Age: %d\n", students[i].age);
            printf("Address: %s\n", students[i].address);
            found = 1;
            break;
        }
    }
    if (!found) {
        printf("Student with ID %d not found.\n", targetID);
    }
}

int main() {
    struct Student students[MAX_STUDENTS];
    int numStudents;

    
    printf("Enter the number of students (up to %d): ", MAX_STUDENTS);
    scanf("%d", &numStudents);

    
    for (int i = 0; i < numStudents; i++) {
        printf("Enter details for student %d:\n", i + 1);
        printf("ID: ");
        scanf("%d", &students[i].ID);
        printf("Name: ");
        scanf("%s", students[i].name);
        printf("Age (between 18 and 24): ");
        scanf("%d", &students[i].age);
        if (students[i].age < 18 || students[i].age > 24) {
            printf("Invalid age. Please enter an age between 18 and 24.\n");
            return 1;
        }
        printf("Address: ");
        scanf("%s", students[i].address);
    }

    
    int targetID;
    printf("Enter the ID of the student whose details you want to see: ");
    scanf("%d", &targetID);

    
    displayStudentDetails(students, numStudents, targetID);

    return 0;
}
